import type { SVGProps } from 'react';

interface CustomIconProps extends SVGProps<SVGSVGElement> {
    size?: number;
    fill?: string;
    stroke?: string;
    strokeWidth?: number;
    viewBox?: string;
}

const userLock = ({
    size = 24,
    fill = 'none',
    stroke = 'none',
    strokeWidth = 1,
    viewBox = '0 0 19 20',
    ...props
} : CustomIconProps ) => (
    <svg
        width={size}
        height={size}
        fill={fill}
        stroke={stroke}
        strokeWidth={strokeWidth}
        viewBox={viewBox}
        strokeLinecap="round"
        strokeLinejoin="round"
        xmlns="http://www.w3.org/2000/svg"
        {...props}
    >
        <path
            d="M2 16.5C1.45 16.5 0.979167 16.3042 0.5875 15.9125C0.195833 15.5208 0 15.05 0 14.5V13.7C0 13.1333 0.145833 12.6125 0.4375 12.1375C0.729167 11.6625 1.11667 11.3 1.6 11.05C2.63333 10.5333 3.68333 10.1458 4.75 9.8875C5.81667 9.62917 6.9 9.5 8 9.5C8.23333 9.5 8.46667 9.50417 8.7 9.5125C8.93333 9.52083 9.16667 9.54167 9.4 9.575C9.58333 9.59167 9.72917 9.6625 9.8375 9.7875C9.94583 9.9125 10 10.0667 10 10.25C10.0333 11.0333 10.225 11.7708 10.575 12.4625C10.925 13.1542 11.3917 13.7417 11.975 14.225C12.0917 14.3083 12.1833 14.4125 12.25 14.5375C12.3167 14.6625 12.35 14.8 12.35 14.95V15.5C12.35 15.7833 12.2542 16.0208 12.0625 16.2125C11.8708 16.4042 11.6333 16.5 11.35 16.5H2ZM8 8.5C6.9 8.5 5.95833 8.10833 5.175 7.325C4.39167 6.54167 4 5.6 4 4.5C4 3.4 4.39167 2.45833 5.175 1.675C5.95833 0.891667 6.9 0.5 8 0.5C9.1 0.5 10.0417 0.891667 10.825 1.675C11.6083 2.45833 12 3.4 12 4.5C12 5.6 11.6083 6.54167 10.825 7.325C10.0417 8.10833 9.1 8.5 8 8.5ZM15.5 10.5C15.7833 10.5 16.0208 10.4042 16.2125 10.2125C16.4042 10.0208 16.5 9.78333 16.5 9.5C16.5 9.21667 16.4042 8.97917 16.2125 8.7875C16.0208 8.59583 15.7833 8.5 15.5 8.5C15.2167 8.5 14.9792 8.59583 14.7875 8.7875C14.5958 8.97917 14.5 9.21667 14.5 9.5C14.5 9.78333 14.5958 10.0208 14.7875 10.2125C14.9792 10.4042 15.2167 10.5 15.5 10.5ZM15.65 19.15L14.65 18.15C14.6167 18.1167 14.5667 18 14.5 17.8V13.35C13.7667 13.1333 13.1667 12.7208 12.7 12.1125C12.2333 11.5042 12 10.8 12 10C12 9.03333 12.3417 8.20833 13.025 7.525C13.7083 6.84167 14.5333 6.5 15.5 6.5C16.4667 6.5 17.2917 6.84167 17.975 7.525C18.6583 8.20833 19 9.03333 19 10C19 10.75 18.7875 11.4167 18.3625 12C17.9375 12.5833 17.4 13 16.75 13.25L17.65 14.15C17.75 14.25 17.8 14.3667 17.8 14.5C17.8 14.6333 17.75 14.75 17.65 14.85L16.85 15.65C16.75 15.75 16.7 15.8667 16.7 16C16.7 16.1333 16.75 16.25 16.85 16.35L17.65 17.15C17.75 17.25 17.8 17.3667 17.8 17.5C17.8 17.6333 17.75 17.75 17.65 17.85L16.35 19.15C16.25 19.25 16.1333 19.3 16 19.3C15.8667 19.3 15.75 19.25 15.65 19.15Z"
        />
    </svg>
);

export default userLock;